config.widgets.module('select',
    [],
    () => {
        return {
            vue: true,
            name: 'gx-config-select',
            template: '#config-select',
            props: {
                label: {
                    required: true,
                    type: String
                },
                values: {
                    required: true,
                    type: Array
                },
                defaultValue: {
                    type: String
                }
            },
            data() {
                return {
                    input: this.defaultValue
                }
            },
            watch: {
                input(val) {
                    this.$emit('input', val);
                }
            },
            methods: {
                getPhrase(title) {
                    const phraseSection = title.split('.');
                    const section = phraseSection[0];
                    const phrase = phraseSection[1];

                    return jse.core.lang.translate(phrase, section);
                }
            },
            init: done => done()
        }
    });